<%@ Control Language="c#" AutoEventWireup="false" Codebehind="TimeTrackingApproveView.ascx.cs" Inherits="Mediachase.UI.Web.TimeTracking.Modules.TimeTrackingApproveView" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="DTCC" src="..\..\Modules\DateTimeClientControl.ascx" %>
<TABLE class="text" cellSpacing="0" cellPadding="0" border="0" width="100%">
	<tr>
		<td class="ibn-navline ibn-alternating text" 
			style="PADDING:7px">
			<b><span style="width:80px"><%=LocRM.GetString("Project")%>:</b></span>
			<asp:Label Runat=server ID="lblProject" CssClass="text"></asp:Label>
			<br><br>
			<b><span style="width:80px"><%=LocRM.GetString("tUser")%>:</b></span>
			<asp:Label Runat=server ID="lblUser" CssClass="text"></asp:Label>
			<br><br>
			<b><span style="width:80px"><%=LocRM.GetString("Week")%>:</b></span>
			<asp:Label Runat=server ID="lblWeek" CssClass="text"></asp:Label>
		</td>
	</tr>
	<tr>
		<td style="PADDING-BOTTOM:5px;padding-top:5px" class="ibn-propertysheet" valign="top">
			<asp:DataGrid id="dgTimesheet" runat="server" AllowPaging="False" cellpadding="0" gridlines="Horizontal" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%">
				<columns>
					<asp:boundcolumn visible="False" datafield="ObjectTypeId" ReadOnly="True"></asp:boundcolumn>
					<asp:boundcolumn visible="False" datafield="ObjectId" ReadOnly="True"></asp:boundcolumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							&nbsp;<%# DataBinder.Eval(Container.DataItem,"Title")%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="200px"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem,"UserComments")%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="70px"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetHours((int)DataBinder.Eval(Container.DataItem,"Total"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="70px"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<%# Mediachase.UI.Web.Util.CommonHelper.GetHours((int)DataBinder.Eval(Container.DataItem,"TotalApproved"))%>
						</ItemTemplate>
						<EditItemTemplate>
							<ibn:DTCC id="dtc" Value='<%# GetDateTimeFromMinutes((int)DataBinder.Eval(Container.DataItem,"TotalApproved")) %>' Path_Img="../Layouts/Images/" Path_JS="../Scripts/" File_JS="mcCalendScript.js" ControlViewType="OnlyTime" ShowTime=HM TimeSpin="true" HourSpinUnLimited="True" ViewStartDate="True" PostBackInit="True" runat="server" />
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="60px"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<%# ((decimal)DataBinder.Eval(Container.DataItem,"Rate")).ToString("f")%>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:TextBox CssClass ="text" Runat="server" ID="txtRate" Width="50px" Text='<%# ((decimal)DataBinder.Eval(Container.DataItem,"Rate")).ToString("f") %>'>
							</asp:TextBox>
							<asp:RequiredFieldValidator ErrorMessage="*" Display="Dynamic" ControlToValidate="txtRate" Runat="server" ID="rfRate"></asp:RequiredFieldValidator>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="50px"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<%# ((decimal)DataBinder.Eval(Container.DataItem,"Cost")).ToString("f")%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh-right" Width="50px"></headerstyle>
						<itemstyle cssclass="ibn-vb2"></itemstyle>
						<ItemTemplate>
							<asp:imagebutton id="ibEdit" runat="server" borderwidth="0" title='<%# LocRM.GetString("Edit")%>' imageurl="../../layouts/images/Edit.gif" commandname="Edit" causesvalidation="False">
							</asp:imagebutton>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:imagebutton id="ibSave" runat="server" borderwidth="0" title='<%# LocRM.GetString("Save")%>' imageurl="../../layouts/images/Saveitem.gif" commandname="Update" causesvalidation="True">
							</asp:imagebutton>&nbsp;
							<asp:imagebutton id="ibCancel" runat="server" borderwidth="0" imageurl="../../layouts/images/cancel.gif" title='<%# LocRM.GetString("Cancel")%>' commandname="Cancel" causesvalidation="False">
							</asp:imagebutton>
						</EditItemTemplate>
					</asp:TemplateColumn>
				</Columns>
			</asp:DataGrid>
		</td>
	</tr>
</table>